<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }
/*
Template Name: Espace privé
*/
$context = Timber::get_context();
$context['body_class'] = 'private-space';
$post = Timber::query_post();
$context['post'] = $post;
$page_roles = get_post_meta($post->ID, '_members_access_role');
$isAuthorized = false;
if( is_user_logged_in() ) {
    $user = wp_get_current_user();
    $roles = $user->roles;
    foreach ($roles as $role) {
        if(in_array($role, $page_roles)) {
            $isAuthorized = true;
        }
    }
} else {
    //redirect login
    global $wp;
    wp_redirect( wp_login_url( site_url( $wp->request ) ) );
}

$context['isAuthorized'] = $isAuthorized;
if($isAuthorized) {
    // get blocks
    $blocks = get_field('files_group');
    $context['file_menu'] = [];
    $context['files_group'] = [];
    foreach ($blocks as $block) {
        if(isset($block['files_group_title'])) {
            $key = sanitize_title($block['files_group_title']);
            $context['file_menu'][$key] = $block['files_group_title'];
            if(isset($block['files'])) {
                foreach ($block['files'] as $file) {
                    $context['files_group'][$key]['title'] = $block['files_group_title'];
                    $context['files_group'][$key]['files'][] = $file;
                }
            }
        }

    }
}

$templates = array('modules/privatespace/list.twig');
Timber::render( $templates, $context );