<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

function faq_postType() {
    $labels = array(
        'name'               => _x( 'FAQ', 'post type general name', 'bb-theme' ),
        'singular_name'      => _x( 'FAQ', 'post type singular name', 'bb-theme' ),
        'add_new'            => _x( 'Ajouter une question', 'Ajouter une question', 'bb-theme' ),
        'add_new_item'       => __( 'Nouvelle question', 'bb-theme' ),
        'edit_item'          => __( 'Éditer question', 'bb-theme' ),
        'new_item'           => __( 'Nouvelle question', 'bb-theme' ),
        'all_items'          => __( 'Toutes les questions', 'bb-theme' ),
        'view_item'          => __( 'Voir question', 'bb-theme' ),
        'search_items'       => __( 'Search', 'bb-theme' ),
        'not_found'          => __( 'Not found', 'bb-theme' ),
        'not_found_in_trash' => __( 'Not found in the trash', 'bb-theme' ),
        'parent_item_colon'  => '',
        'menu_name'          => __( 'FAQ', 'bb-theme' )
    );
    $args = array(
        'labels'        => $labels,
        'menu_icon'          => 'dashicons-clipboard',
        'description'   => 'FAQ gestion',
        'public'        => false, //page détail
        'show_ui' => true,
        'publicly_queryable' => false,
        'exclude_from_search' => false,
        'menu_position' => 2,
        /*Simple Page Ordering => page-attributes,hierarchical=true */
        'supports'      => array( 'title','editor', 'page-attributes' ),
        'hierarchical' => true,
        'has_archive'   => false, //set default page for /customposttype or use templatte archie-{custom}.php
    );
    register_post_type( 'faq', $args );
}
add_action( 'init', 'faq_postType' );


//categorie of faq
function faqCategorie_init() {
    // create a new taxonomy
    register_taxonomy(
        'faq_categorie',
        'faq',
        array(
            'label' => __( 'Catégorie de FAQ', 'bb-theme' ),
            'hierarchical'      => false,
            'show_ui'           => true,
            'show_admin_column' => true,
        )
    );
}
add_action( 'init', 'faqCategorie_init' );

//for single select https://gist.github.com/sudar/e2f97e1455b30dc71d07