<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }


// ACF upload prefilter
function acf_upload_dir_prefilter($errors, $file, $field) {
    // Only allow editors and admins, change capability as you see fit
    if( !current_user_can('edit_pages') ) {
        $errors[] = 'Only Editors and Administrators may upload attachments';
    }
    // This filter changes directory just for item being uploaded
    add_filter('upload_dir', 'custom_upload_dir');
}
add_filter('acf/upload_prefilter/key=field_5f3fee6b3cf62', 'acf_upload_dir_prefilter', 10, 3 );

// Custom upload directory
function custom_upload_dir($param) {
    $custom_dir = '/uploads/private-space';
    $param['path'] = WP_CONTENT_DIR . $custom_dir;
    $param['url'] = WP_CONTENT_URL . $custom_dir;
    return $param;
}

//IN HTACCESS -> permet l'accès uniquement si connecté [pas de test sur role]
#Protéger wp-content/uploads/private-space
//RewriteCond %{THE_REQUEST} ^[A-Z]{3,9}\ /wp-content/uploads/private-space.*$ [NC]
//RewriteCond %{HTTP_COOKIE} !^.*wordpress_logged_in.*$ [NC]
//RewriteRule .* - [F,NS,L]
