<?php if ( ! defined( 'ABSPATH' ) ) {die;}


add_action( 'after_setup_theme', 'load_plugin' );
function load_plugin() {
    if (!class_exists('ACF')) {
        // Define path and URL to the ACF plugin.
        define( 'MY_ACF_PATH', plugin_dir_path( __FILE__ )  . '/acf/' );
        define( 'MY_ACF_URL', BB_PLUGIN_BASE_URL .'gutenberg-builder/acf/' );
        // Include the ACF plugin.
        include_once( MY_ACF_PATH . 'acf.php' );
        // Customize the url setting to fix incorrect asset URLs.
        add_filter('acf/settings/url', 'my_acf_settings_url');
        function my_acf_settings_url( $url ) {
            return MY_ACF_URL;
        }
        add_filter('acf/settings/show_admin', 'my_acf_settings_show_admin');
        function my_acf_settings_show_admin( $show_admin ) {
            return false;
        }
    }

    //load Fieds
    foreach (glob(plugin_dir_path( __FILE__ ) ."acf_fields/*.php") as $filename) {
        include_once $filename;
    }

    //ini blocks
    /* AUTORISER QUE LES BLOCKS CRÉÉS ?!
    function twn_allowed_block_types( $allowed_block_types, $post ) {
        return array( 'acf/slider','acf/blog-posts', 'acf/content', 'acf/button', 'core-embed/youtube', 'core/quote' );
    }
    add_filter( 'allowed_block_types', 'twn_allowed_block_types', 10, 2 );
    */

    include_once plugin_dir_path( __FILE__ ) . 'class/RegisterBlockClass.php';
    $registerBlockClass = new RegisterBlockClass();
    //remove unused in specific project
    $registerBlockClass->registerNewBlockOnACF('bb-block-banner',"Bannière de page", 'banner' );
    $registerBlockClass->registerNewBlockOnACF('blog-posts',"Block liste d'articles", 'blogPosts' );
    $registerBlockClass->registerNewBlockOnACF('bb-block-titre',"Block Titre", 'title' );
    $registerBlockClass->registerNewBlockOnACF('bb-block-slider',"Block Slider", 'slider' );
    $registerBlockClass->registerNewBlockOnACF('bb-block-counter',"Block Counter", 'counter' );
    $registerBlockClass->registerNewBlockOnACF('bb-simple-slide',"Block Simple slider", 'simple_slide' );
    $registerBlockClass->registerNewBlockOnACF('bb-block-checklist',"Block Checklist", 'checklist' );
    $registerBlockClass->registerNewBlockOnACF('bb-block-tabs',"Block Tabs", 'tabs' );

    //permettre de mettre en pleine largeur les block (container-fluid)
    global $_wp_theme_features;
    if( !isset($_wp_theme_features['align-wide']) ) $_wp_theme_features['align-wide'] = true;

}


function bb_plugin_block_group( $categories, $post ) {
    return array_merge(
        $categories,
        array(
            array(
                'slug' => 'bb-blocks',
                'title' => __( ' BB Blocks', 'twn-theme' ),
            ),
        )
    );
}
add_filter( 'block_categories', 'bb_plugin_block_group', 10, 2 );