<?php
$context            = Timber::get_context();
$post               = new TimberPost();
$context['post']    = $post;
$context['fields']  = get_fields();
//include JS / CSS
wp_enqueue_style( 'block-slider-swiper-styles', get_template_directory_uri()  . '/assets/dist/lib/swiper/css/swiper.min.css' );
wp_enqueue_script( 'block-slider-swiper-scripts',  get_template_directory_uri() .'/assets/dist/lib/swiper/swiper.min.js', array('jquery'), '', true );
// PREPARE FIELD DATA
// Slides data ------
if(!class_exists('Slide')) {
    include_once plugin_dir_path( __FILE__ ) . '../class/Slide.php';
}

$slides = [];
if (isset($context['fields']) && is_array($context['fields'])) {
    // SLIDES
    // ---------------------
    if (isset($context['fields']['slides'])) {
        foreach ($context['fields']['slides'] as $key => $slideData) {
            //print_r($slideData);
            $slide = new Slide();
            //from MANUAL
            if ($slideData['data_source'] === 'manual') {
                $slide->setTitle($slideData['title']);
                $slide->setSubTitle($slideData['subtitle']);
                $slide->setImageSrc($slideData['image']['url']);
                $slide->setCaption($slideData['caption']);
                $linkUrl = false;
                if($slideData['link'] and isset($slideData['link']['url'])) {
                    $linkUrl = $slideData['link']['url'];
                    if(isset($slideData['link']['target']) and $slideData['link']['target']) {
                        $slide->setTarget($slideData['link']['target']);
                    }
                }
                $slide->setLink($linkUrl);
                $slides[] = $slide;
            }
            //from POST
            if ($slideData['data_source'] === 'article') {
                // GET DATA from article
                $post_data = get_post($slideData['article']);
                if(!is_null($post_data)) {
                    $slide->setTitle($post_data->post_title);
                    //IMAGE
                    $thumbnailSrc = apply_filters( "dolmen/slider_slide_image", $post_data );
                    if(!$thumbnailSrc) {
                        $thumbnailSrc = get_the_post_thumbnail_url($post_data->post_ID);
                    }
                    $slide->setImageSrc($thumbnailSrc);
                    $slide->setCaption(get_the_excerpt($post_data));
                    $slide->setLink(get_permalink($post_data->ID));
                    $slides[] = $slide;
                }
            }
        }
    }
}
$context['slides'] = $slides;
Timber::render('blocks/slider/view.twig', $context);
