<?php 

$context         = Timber::get_context();
$post            = new TimberPost();
$context['block'] = $block;
$context['fields'] = get_fields();

$galleries = array();

foreach($context['fields']['galleries'] as $key => $gallery):
    $slug = sanitize_title($gallery['gallery_title']);
    $context['fields']['galleries'][$key]['gallery_slug'] = $slug;
    $galleries[$slug] = array();
    foreach($gallery['images'] as $image):
        $galleries[$slug][] = array(
            'src' => $image['url'],
            'w' => $image['width'],
            'h' => $image['height'],
            'msrc' => $image['sizes']['medium'],
            'title' => $image['title']
        );
    endforeach;
endforeach;

wp_localize_script('block-gallery-script', 'galleries', $galleries);

Timber::render('gallery/view.twig', $context);