<?php
include plugin_dir_path( __FILE__ ) . '/fields.php';

function register_acf_block_gallery() {
    // register a testimonial block.
    acf_register_block_type(array(
        'name'              => 'gallery-list',
        'title'             => __('Gallery list'),
        'description'       => __("List of photo galleries"),
        'render_template'   => plugin_dir_path( __FILE__ ). 'template.php',
        'category'          => 'common',
        'icon'              => 'images-alt2',
        'mode'              => 'edit',
        'keywords'          => array( 'gallery', 'images', 'title' ),
        'supports' => [
            'align' => array( 'full', 'wide', 'center', 'left', 'right' ),
        ],
        'enqueue_assets'    => function(){
            wp_enqueue_style( 'block-gallery-photoswipe-styles', plugin_dir_url( __DIR__ )  . '../assets/photoswipe/photoswipe.css' );
            wp_enqueue_style( 'block-gallery-photoswipe-styles-default', plugin_dir_url( __DIR__ )  . '../assets/photoswipe/default-skin/default-skin.css' );
            wp_enqueue_style( 'block-gallery-styles', plugin_dir_url( __FILE__ )  . 'style.css' );
            wp_enqueue_script( 'block-gallery-photoswipe-scripts', plugin_dir_url( __DIR__ )  . '../assets/photoswipe/photoswipe.min.js', array('jquery'), '', true );
            wp_enqueue_script( 'block-gallery-photoswipe-scripts-ui', plugin_dir_url( __DIR__ )  . '../assets/photoswipe/photoswipe-ui-default.min.js', array('block-gallery-photoswipe-scripts'), '', true );
            wp_enqueue_script( 'block-gallery-script', plugin_dir_url( __FILE__ )  . 'script.min.js' , array('block-gallery-photoswipe-scripts-ui'), '', true);
        }
    ));
}

// Check if function exists and hook into setup.
if( function_exists('acf_register_block_type') ) {
    add_action('acf/init', 'iniLocalFieldGalleryGroups' );
    add_action('acf/init', 'register_acf_block_gallery');
}