<?php
include plugin_dir_path( __FILE__ ) . '/fields.php';

function register_acf_block_content() {
    // register a testimonial block.
    acf_register_block_type(array(
        'name'              => 'content',
        'title'             => __('Block Contenu'),
        'description'       => __("Contenu riche: texte, imges ..."),
        'render_template'   => plugin_dir_path( __FILE__ ). 'template.php',
        'category'          => 'common',
        'mode'              => 'edit',
        'keywords'          => array( 'contenu', 'paragraphe', 'titre' ),
        'supports' => [
            'align' => array( 'full' ),
        ],
        'enqueue_assets'    => function(){
            wp_enqueue_script( 'block-content-script', plugin_dir_url( __FILE__ )  . 'script.min.js' , array(), '', true);
        }
    ));
}

// Check if function exists and hook into setup.
if( function_exists('acf_register_block_type') ) {
    add_action('acf/init', 'iniLocalFieldContentGroups' );
    add_action('acf/init', 'register_acf_block_content');
}