<?php
include plugin_dir_path( __FILE__ ) . '/fields.php';

function register_acf_button_posts() {
    // register a testimonial block.
    acf_register_block_type(array(
        'name'              => 'button',
        'title'             => __("Block Bouton"),
        'description'       => __("Ajouter un lien vers une page ou une url"),
        'render_template'   => plugin_dir_path( __FILE__ ). 'template.php',
        'category'          => 'common',
        'icon'              => '<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title/><g data-name="36.option-memu" id="_36.option-memu"><rect class="acfb_svg_icon" height="4" width="4" x="1" y="10"/><rect class="acfb_svg_icon" height="4" width="4" x="10" y="10"/><rect class="acfb_svg_icon" height="4" width="4" x="19" y="10"/></g></svg>',
        'mode'              => 'edit',
        'keywords'          => array( 'button', 'bouton', 'lien' ),
        'supports' => [
            'align' => array( 'full' ),
        ]
    ));
}

// Check if function exists and hook into setup.
if( function_exists('acf_register_block_type') ) {
    add_action('acf/init', 'iniLocalFieldButtonGroups' );
    add_action('acf/init', 'register_acf_button_posts');
}