<?php

$context         = Timber::get_context();
$post            = new TimberPost();
$context['block']  = $block;
$context['fields'] = get_fields();

// somehow on my dev system only page existed, NOT paged
//$paged = -1;
//if (!empty($GLOBALS['paged'])){
//    $paged = $GLOBALS['paged'];
//} else {
//    if (!empty($GLOBALS['page'])){
//        $paged = $GLOBALS['page'];
//    }
//}
//if ($paged === -1) {
//    $paged = 1;
//}

//selection d'articles
$postsList = [];
if( have_rows('articles') ) {
    while( have_rows('articles') ) : the_row();
        $postsList[] = new Timber\Post(get_sub_field('article')->ID);
    endwhile;
} else {
    //liste d'articles
    $nbPosts = get_field('nombre_articles');
    $categoriesFilter = get_field('filtre_par_categories');
    $use_pagination = get_field('use_pagination') === true;
    $args = [
        'posts_per_page'   => $nbPosts,
        'category__in'     => $categoriesFilter,
        'orderby'          => 'date',
        'order'            => 'DESC',
        'post_type'        => 'post',
        'post_status'      => 'publish',
        'suppress_filters' => true
    ];
//    if ($use_pagination) {
//        $args['paged'] = $paged;
//        $args['suppress_filters'] = false;
//    }
//    $postsList = new Timber\PostQuery($args); //retourne un mauvais ordre !!

    $postsList = get_posts($args);
    $posts = [];
    foreach ($postsList as $post) {
        $posts[] = new Timber\Post($post);
    }
//
//    if ($use_pagination) {
//        $postsList->pagination([
//            // 'show_all' => false,
//            'mid_size' => 2,
//            'end_size' => 1
//        ]);
//    }
}

$context['posts'] = $posts;
Timber::render('blocks/blog-posts/list.twig', $context);
