<?php  if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

//wp_ajax_<actionName> , _nopriv pour non loggué mais inutile ici
add_action( 'wp_ajax_saveResearch', 'ajax_saveResearch' );
function ajax_saveResearch() {
    $current_user = wp_get_current_user();
    $currentUserId = $current_user->ID;
    if ( 0 == $currentUserId ) { //not logedd in
        //inutile on ne traite que le cas loggué
        //save as cookie
        //https://wordpress.stackexchange.com/questions/255007/add-user-meta-after-a-user-has-registered-and-logged-in

    } else {
        $search = [];
        if(isset($_POST['query']) and isset($_POST['search-name'])) {
            $search['query'] = $_POST['query'];
            $search['search-name'] = $_POST['search-name'];
        }
        add_user_meta( $currentUserId, 'savedSearch', $search);
    }


    $return = array(
        'message'  => __('Recherche sauvegardée', 'bb-theme'),
    );
    wp_send_json($return);
}

//supprimer une recherche deleteSavedResearch&search=under%201015 404 (Not Found)
add_action( 'wp_ajax_deleteSavedResearch', 'ajax_deleteSavedResearch' );
function ajax_deleteSavedResearch() {
    $search = $_GET['search'];
//    check_ajax_referer( 'fav_authors_obj_ajax', 'security' ); ?? TODO
    $current_user = wp_get_current_user();
    $currentUserId = $current_user->ID;
    $userCurrentSavedResearchs = get_user_meta( $currentUserId, 'savedSearch');
//    die(var_dump($userCurrentSavedResearchs));
//    unset($userCurrentSavedResearchs[1]);
    delete_user_meta( $currentUserId, 'savedSearch');
    foreach ($userCurrentSavedResearchs as $key=>$userCurrentSavedResearch) {
        if(!empty($userCurrentSavedResearch) and $userCurrentSavedResearch['search-name'] != $_GET['search']) {
            add_user_meta( $currentUserId, 'savedSearch', $userCurrentSavedResearch);
        }
    }
    wp_send_json(['ok']);
}


//add to account
//https://github.com/woocommerce/woocommerce/wiki/Customising-account-page-tabs
/**
 * Insert the new endpoint into the My Account menu.
 *
 * @param array $items
 * @return array
 */
function savedSearch_account_menu_items( $items ) {
    // Remove the logout menu item.
    $logout = $items['customer-logout'];
    unset( $items['customer-logout'] );
    // Insert your custom endpoint.
    $items['saved-search'] = __( 'Recherches sauvegardées', 'bb-theme' );

    // Insert back the logout item. Pour modficier l'ordre ...
    $items['customer-logout'] = $logout;

    //
    unset( $items['dashboard'] );
    unset( $items['downloads'] );

    return $items;
}
add_filter( 'woocommerce_account_menu_items', 'savedSearch_account_menu_items' );

/**
 * Endpoint HTML content.
 */
function saved_search_endpoint_content() {
    $savedSearchs = get_user_meta(wp_get_current_user()->ID, 'savedSearch');
    $html = "<ul class='saved-search-list'><h3 class='title-2'>".__( 'Recherches sauvegardées', 'bb-theme' )."</h3>";
    if(!empty($savedSearchs)) {
        $baseShopUrl = get_post_type_archive_link('product');
        foreach ($savedSearchs as $key=>$savedSearch) {
            if(isset($savedSearch['query']) and $savedSearch['search-name']) {
                $html = $html."<li class='saved-".$key."'><a href='".$baseShopUrl."?".$savedSearch['query']."'><i class='ti-clip'></i>".$savedSearch['search-name']."</a>";
                $html = $html."<a href='/wp-admin/admin-ajax.php?action=deleteSavedResearch&search=".$savedSearch['search-name']."' 
                        class='delete-search' onclick='deleteSavedResearch(event, this.href, this.id)' id=".$key."><i class='ti-trash'></i></a></li>";
            }
        }
    }
    $html =$html."</ul>";
    echo $html;
}

add_action( 'woocommerce_account_saved-search_endpoint', 'saved_search_endpoint_content' );

/**
 * Register new endpoint to use inside My Account page.
 *
 * @see https://developer.wordpress.org/reference/functions/add_rewrite_endpoint/
 */
function saved_search_endpoints() {
    add_rewrite_endpoint( 'saved-search', EP_ROOT | EP_PAGES );
}

add_action( 'init', 'saved_search_endpoints' );
/**
 * Add new query var.
 *
 * @param array $vars
 * @return array
 */
function saved_search_query_vars( $vars ) {
    $vars[] = 'saved-search';

    return $vars;
}

add_filter( 'query_vars', 'saved_search_query_vars', 0 );


/**
 * Flush rewrite rules on theme activation.
 */
function bb_flush_rewrite_rules() {
    add_rewrite_endpoint( 'saved-search', EP_ROOT | EP_PAGES );
    flush_rewrite_rules();
}

add_action( 'after_switch_theme', 'bb_flush_rewrite_rules' );