<?php  if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

//wp_ajax_<actionName> , _nopriv pour non loggué mais inutile ici
add_action( 'wp_ajax_saveFavourites', 'ajax_saveFavourites' );
function ajax_saveFavourites() {
    $current_user = wp_get_current_user();
    $currentUserId = $current_user->ID;
    if ( 0 == $currentUserId ) { //not logedd in
    } else {
        $favourites = get_user_meta( $currentUserId, 'savedFavourites', true );
        if( empty( $favourites ) ){
            $favourites = [];
        }
        if(isset($_POST['product-url']) and isset($_POST['product-id'])) {
            $favourites[$_POST['product-id']] = $_POST['product-url'];
        }
        update_user_meta( $currentUserId, 'savedFavourites', $favourites);
    }
    $return = array(
        'message'  => __('Produit en Favoris', 'bb-theme'),
    );
    wp_send_json($return);
}

//supprimer une recherche deleteSavedRefavourite&favourite=under%201015 404 (Not Found)
add_action( 'wp_ajax_deleteSavedFavourite', 'ajax_deleteSavedFavourite' );
function ajax_deleteSavedFavourite() {
    $productId = $_GET['favourite'];
    $currentUserId = wp_get_current_user()->ID;
    $favourites = get_user_meta( $currentUserId, 'savedFavourites', true );
    unset($favourites[$productId]);
    update_user_meta( $currentUserId, 'savedFavourites', $favourites);
    wp_send_json(['ok']);
}


//add to account
/**
 * Insert the new endpoint into the My Account menu.
 *
 * @param array $items
 * @return array
 */
function savedFavourites_account_menu_items( $items ) {
    // Remove the logout menu item.
    $logout = $items['customer-logout'];
    unset( $items['customer-logout'] );
    // Insert your custom endpoint.
    $items['saved-favourites'] = __( 'Produits favoris', 'bb-theme' );
    // Insert back the logout item. Pour modifier l'ordre ...
    $items['customer-logout'] = $logout;
    return $items;
}
add_filter( 'woocommerce_account_menu_items', 'savedFavourites_account_menu_items' );

/**
 * Endpoint HTML content.
 */
function saved_favourites_endpoint_content() {
    $savedFavouritess = get_user_meta( wp_get_current_user()->ID, 'savedFavourites', true );
    $html = "<ul class='saved-favourite-list'><h3 class='title-2'>".__( 'Produits favoris', 'bb-theme' )."</h3>";
    if(!empty($savedFavouritess)) {
        foreach ($savedFavouritess as $productId => $productWithContextURL) {
            $product = wc_get_product( $productId );
            if($product) {
                $html = $html."<li class='saved-".$productId."'><a href='".$productWithContextURL."'>".$product->get_name()."</a>";
            $html = $html."<a href='/wp-admin/admin-ajax.php?action=deleteSavedFavourite&favourite=".$productId."'
                    class='delete-favourite' onclick='deleteSavedResearch(event, this.href, this.id)' id=".$productId."><i class='ti-trash'></i></a></li>";
            }
        }
    }
    $html =$html."</ul>";
    echo $html;
}

add_action( 'woocommerce_account_saved-favourites_endpoint', 'saved_favourites_endpoint_content' );

/**
 * Register new endpoint to use inside My Account page.
 *
 * @see https://developer.wordpress.org/reference/functions/add_rewrite_endpoint/
 */
function saved_favourite_endpoints() {
    add_rewrite_endpoint( 'saved-favourites', EP_ROOT | EP_PAGES );
}
add_action( 'init', 'saved_favourite_endpoints' );

/**
 * Add new query var.
 *
 * @param array $vars
 * @return array
 */
function saved_favourite_query_vars( $vars ) {
    $vars[] = 'saved-favourites';
    return $vars;
}
add_filter( 'query_vars', 'saved_favourite_query_vars', 0 );


/**
 * Flush rewrite rules on theme activation.
 */
function bb_flush_rewrite_rules_favourites() {
    add_rewrite_endpoint( 'saved-favourites', EP_ROOT | EP_PAGES );
    flush_rewrite_rules();
}
add_action( 'after_switch_theme', 'bb_flush_rewrite_rules_favourites' );

