<?php  if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }


function loadWooFrontScripts() {
    $path = null;
    $setBaseAssetsPath = apply_filters( 'woocommerce_get_asset_url', plugins_url( $path, WC_PLUGIN_FILE )).'/';
    $suffix = '.min';
    $assetsJs = [
        'select2'                    => array(
            'src'     => $setBaseAssetsPath. 'assets/js/select2/select2.full' . $suffix . '.js' ,
            'deps'    => array( 'jquery' ),
            'version' => '4.0.3',
        ),
        'selectWoo'                  => array(
            'src'     => $setBaseAssetsPath.'assets/js/selectWoo/selectWoo.full' . $suffix . '.js' ,
            'deps'    => array( 'jquery' ),
            'version' => '1.0.6',
        ),
        'wc-address-i18n'            => array(
            'src'     => $setBaseAssetsPath. 'assets/js/frontend/address-i18n' . $suffix . '.js',
            'deps'    => array( 'jquery', 'wc-country-select' ),
            'version' => WC_VERSION,
        ),
        'wc-checkout'                => array(
            'src'     => $setBaseAssetsPath. 'assets/js/frontend/checkout' . $suffix . '.js' ,
            'deps'    => array( 'jquery', 'woocommerce', 'wc-country-select', 'wc-address-i18n' ),
            'version' => WC_VERSION,
        ),
        'wc-country-select'          => array(
            'src'     => $setBaseAssetsPath. 'assets/js/frontend/country-select' . $suffix . '.js' ,
            'deps'    => array( 'jquery' ),
            'version' => WC_VERSION,
        )
    ];
    foreach ($assetsJs as $handle=>$asset) {
        wp_register_script( $handle, $asset['src'], $asset['deps'], $asset['version'], true );
        wp_enqueue_script( $handle );
    }
    //add css select2
    $assetsCss = [
        'select2'                     => array(
            'src'     => $setBaseAssetsPath. 'assets/css/select2.css' ,
            'deps'    => array(),
            'version' => WC_VERSION,
            'has_rtl' => false,
        ),
    ];
    foreach ($assetsCss as $handle=>$asset) {
        wp_register_style( $handle, $asset['src'], $asset['deps'], $asset['version'], 'all' );
        wp_enqueue_style( $handle );
    }
}