<?php

class RecentlyViewedProduct {

    protected $viewedProductListIds;

    public function __construct() {
        $this->viewedProductListIds = $this->setViewedProductListIds();
    }

    public function setViewedProductListIds() {
        $viewed_products = ! empty( $_COOKIE['woocommerce_recently_viewed'] ) ? (array) explode( '|', $_COOKIE['woocommerce_recently_viewed'] ) : array();
        return array_reverse( array_filter( array_map( 'absint', $viewed_products ) ) );
    }

    public function getRecentlyViewedProduct($numberOfProduct) {
        $productsViewedEmpty = true;
        $viewed_products = $this->viewedProductListIds;
        if (!empty( $viewed_products ) ) {
            $productsViewedEmpty = false;
        }
        $query_args = $this->getBaseArgsForQuery($numberOfProduct);
        $query_args['post__in'] = $this->viewedProductListIds;
        $productsViewed = new Timber\PostQuery( apply_filters( 'woocommerce_recently_viewed_products_widget_query_args', $query_args ) );
        $similarProducts = [];
        //completer avec des produits similaires
        if(!empty($productsViewed) and count($productsViewed->get_posts()) < $numberOfProduct) {
            $similarProducts = $this->get_similar_product($numberOfProduct - count($productsViewed->get_posts()));
        }
        $nbSimilarProducts = 0;
        if(!empty($similarProducts)) {
            $nbSimilarProducts = count($similarProducts->get_posts());
        }
        //number of prooduct to catch to complete
        $numberOfProductToComplete = $numberOfProduct - count($productsViewed->get_posts()) - $nbSimilarProducts;
        $productsToComplete = [];
        if($numberOfProductToComplete > 0) {
            $query_args = $this->getBaseArgsForQuery($numberOfProduct);
            //filtre par catégorie principale ...
            $query_args['meta_query'] = [
                [
                    'key' => '_meta_status_rule',
                    'value' => 'vente-boutique',
                    'compare' => '=',
                ]
            ];
            $query_args['posts_per_page'] = $numberOfProductToComplete;
            $productsToComplete = new Timber\PostQuery($query_args);
        }
        $products = [];
        foreach ($productsViewed as $productViewed) {
            $products[] = $productViewed;
        }
        foreach ($similarProducts as $similarProduct) {
            $products[] = $similarProduct;
        }
        foreach ($productsToComplete as $productToComplete) {
            $products[] = $productToComplete;
        }
        return [
            'productsViewedEmpty' => $productsViewedEmpty,
            'products' => $products
        ];
    }


    public function getBaseArgsForQuery($numberOfProduct) {
        $query_args = array(
            'posts_per_page' => $numberOfProduct,
            'no_found_rows'  => 1,
            'post_status'    => 'publish',
            'post_type'      => 'product',//filtre par catégorie principale ...
        );
        $query_args['meta_query'] = [
            [
                'key' => '_meta_status_rule',
                'value' => 'vente-boutique',
                'compare' => '=',
            ]
        ];
        if ( 'yes' === get_option( 'woocommerce_hide_out_of_stock_items' ) ) {
            $query_args['tax_query'] = array(
                array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'outofstock',
                    'operator' => 'NOT IN',
                ),
            );
        }
        return $query_args;
    }

    public function get_similar_product($numberOfproductToCatch) {
        $cats_array = [];
        foreach( $this->viewedProductListIds as $product_id ) {
            // get categories
            $categories = wp_get_post_terms( $product_id, 'product_cat' );
            foreach( $categories as $category ) {
                if( ! in_array( $category->term_id, $cats_array ) ) {
                    $cats_array[] = intval( $category->term_id );
                }
            }
        }
        $args = array(
            'post_type'             => 'product',
            'post_status'           => 'publish',
            'post__not_in' => $this->viewedProductListIds,
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => $numberOfproductToCatch,
            'tax_query'             => array(
                array(
                    'taxonomy' => 'product_cat',
                    'field' => 'term_id', //This is optional, as it defaults to 'term_id'
                    'terms'         => $cats_array,
                    'operator'      => 'IN' // Possible values are 'IN', 'NOT IN', 'AND'.
                )
            ),
            'meta_query' => [
                [
                    'key' => '_meta_status_rule',
                    'value' => 'vente-boutique',
                    'compare' => '=',
                ]
            ]
        );
        $products = new Timber\PostQuery($args);
        return $products;

    }

    public function trackViewedProduct($post) {
        if ( empty( $_COOKIE['woocommerce_recently_viewed'] ) ) {
            $viewed_products = array();
        } else {
            $viewed_products = (array) explode( '|', $_COOKIE['woocommerce_recently_viewed'] );
        }

        if (!in_array( $post->ID, $viewed_products ) ) {
            $viewed_products[] = $post->ID;
        }

        if ( sizeof( $viewed_products ) > 15 ) {
            array_shift( $viewed_products );
        }
        // Store for session only
        wc_setcookie( 'woocommerce_recently_viewed', implode( '|', $viewed_products ) );
    }
}