<?php

class CustomVSOTable {
    CONST DATABASE_VERSION = 15;

    public function upgradeDatabaseVSO() {
        global $wpdb;
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE `{$wpdb->base_prefix}VSO_produit` (
          id bigint(20) NOT NULL AUTO_INCREMENT,
          vso_ID bigint(20) NOT NULL,
          product_ID bigint(20) NOT NULL,
          vso_prixEstimation varchar(191) ,
          vso_prixDepart varchar(191),
          vso_nbOffres varchar(191),
          vso_meilleureOffre varchar(191),
          vso_vsoUrn varchar(191),
          vso_prixRealise varchar(191),
          vso_lot int,
          vso_reference varchar(191),
          PRIMARY KEY  (id)
          KEY key_vso_product (vso_ID, product_ID))
        ) $charset_collate;";


        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
        $success = empty($wpdb->last_error);

        return $success;
    }

    public function upgrade() {
        $saved_version = (int) get_site_option('VSO_Produit_table_vesrion');
        if ($saved_version < self::DATABASE_VERSION  ) {
            $this->upgradeDatabaseVSO();
            update_site_option('VSO_Produit_table_vesrion', self::DATABASE_VERSION);
        }
    }
}
