<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

//includ classes
require_once(__DIR__.'/class/RecentlyViewedProduct.php' );

//custom taxonomy

//include functions
require_once(__DIR__.'/functions/saveResearch.php' );
require_once(__DIR__.'/functions/saveFavourites.php' );

require_once(__DIR__.'/functions/registration.php' );

require_once(__DIR__.'/functions/orderBy.php' );

require_once(__DIR__.'/functions/seo.php' );
require_once(__DIR__.'/functions/CustomerOrderDetails.php' );
require_once(__DIR__.'/functions/bb-searchLot.php' );

require_once(__DIR__.'/functions/iniFrontScriptsOnCustomPage.php' );

require_once(__DIR__.'/functions/emailNotification.php' );

require_once(__DIR__.'/class/CustomVSOTable.php');
add_action( 'admin_init', 'upgradeDatabaseVSO' );
function upgradeDatabaseVSO() {
    $upgradeDatabase = new CustomVSOTable();
    $upgradeDatabase->upgrade();
}


function timber_set_product( $post ) {
    global $product;
    if ( is_woocommerce() ) {
        $product = wc_get_product( $post->ID );
    }
}

//To remove the default image thumb
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail' );


//MODIFY locale, pour les pages shop et produits qui ne sont pas traduits ...
function modifyLocale($locale) {
    if(isset($_GET['lang']) and $_GET['lang'] == 'en') {
        $locale = 'en_US';
    }
    $GLOBALS['currentWooLang'] = $locale;
    return $locale;
}
add_filter( 'locale', 'modifyLocale', 999, 3 );

//AJAX Add to cart
//add_action( 'wp_ajax_addToCartAction', 'addToCartAction' );
//
//function addToCartAction() {
//    $product_id = intval($_POST['product_id']);
//    if ( sizeof( WC()->cart->get_cart() ) > 0 ) {
//        foreach ( WC()->cart->get_cart() as $cart_item_key => $values ) {
//            $_product = $values['data'];
//            if ( $_product->get_id() == $product_id ) {
//                $found = true;
//            }
//        }
//        // if product not found, add it
//        if ( ! $found ) {
//            WC()->cart->add_to_cart( $product_id );
//        }
//    } else {
//        WC()->cart->add_to_cart( $product_id );
//    }
//    // Don't forget to stop execution afterward.
//    wp_die();
//}


/**
 * Update cart number of products
 */
add_filter( 'woocommerce_add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment' );

function woocommerce_header_add_to_cart_fragment( $fragments ) {
    global $woocommerce;
    ob_start();
    ?>
        <span id="cart-nb-prod"><?php echo $woocommerce->cart->cart_contents_count;?></span>
    <?php
    $fragments['#cart-nb-prod'] = ob_get_clean();
    return $fragments;
}

/**
 * Add category to search bar / inutile
 * @param $query
 * @return mixed
 */
//function advanced_search_query($query) {
//    $query->set( 'update_post_meta_cache', false );
//    $query->set( 'update_post_term_cache', false );
//}
//add_action('pre_get_posts', 'advanced_search_query', 1000);

//filter only product to sale
function addProductStatusToQuery( $meta_query) {
    if (isset($_GET['product_status']) && !empty($_GET['product_status'])) {
        //en-boutique => product_status=vente-boutique & product_status=vso-en-cours
        if($_GET['product_status'] == 'boutique-vso') {
            $meta_query[] = [
                'relation' => 'OR',
                [
                    'key'     => '_meta_status_rule',
                    'value'   => 'vente-boutique',
                    'compare' => '='
                ],
                [
                    'key'     => '_meta_status_rule',
                    'value'   => 'vso-en-cours',
                    'compare' => '='
                ],
            ];
        } else {
            $meta_query[] = array(
                'key'       => '_meta_status_rule',
                'value' => $_GET['product_status'],
                'compare' => '='
            );
        }
        return $meta_query;
    }
}
add_action( 'woocommerce_product_query_meta_query', 'addProductStatusToQuery' );
//Hook woocommerce_product_query_meta_query aurait été mieux....


add_filter( 'woocommerce_product_query_tax_query', 'filterByTerm', 10, 2 );
function filterByTerm( $tax_query, $query ) {

    $queryArgsFormTerm = ['pa_atelier', 'pa_date', 'pa_metaux', 'pa_metaux', 'pa_conservationav'];

    foreach ($queryArgsFormTerm as $argFormTerm) {
        if(isset($_GET[$argFormTerm]))
            $tax_query[] = array(
                'taxonomy' => $argFormTerm,
                'field'    => 'slug',
                'terms'    => $_GET[$argFormTerm],
                'operator' => 'IN',
            );
    }
    return $tax_query;
};

//edit before shop LOOP, woocommerce_before_shop_loop
remove_action( 'woocommerce_before_shop_loop' , 'woocommerce_result_count', 20 );
add_action('woocommerce_before_shop_loop','getNbProducts',10);
function getNbProducts() {
    //http://woocommerce.wp-a2z.org/oik_api/woocommerce_result_count/
    $nbResults = wc_get_loop_prop( 'total' );
    $label = __('Produit', 'bb-theme');
    if($nbResults > 1) {
        $label = $label.'s';
    }
    echo  "<div class='nb-result'><span>".wc_get_loop_prop( 'total' )."</span> ".$label."</div>";
}


//QUAND ON FAIT UNE REQUETE EN STOCK NE PAS AFFICHER LES PRODUITS STOCK = 0
add_filter( 'woocommerce_product_query_meta_query', 'show_only_products_with_qtdy_min_1', 10, 2 );
function show_only_products_with_qtdy_min_1( $meta_query, $query ) {
    if(isset($_GET['stock']) and $_GET['stock'] == 'instock') {
        $meta_query[] = array(
            'key'     => '_stock',
            'type'    => 'numeric',
            'value'   => 0,
            'compare' => '>'
        );
    }
    return $meta_query;
};

//EDIT FIELDS
//add_filter( 'woocommerce_checkout_fields' , 'custom_override_checkout_fields' );
//function custom_override_checkout_fields( $fields ) {
//    $fields['order']['order_comments']['placeholder'] = 'My new placeholder';
//    $fields['order']['order_comments']['label'] = 'My new label';
//    return $fields;
//}


//NE PAS AFFICHER LES VSO DONT LE ACTIF EST À FALSE !!!
function exclude_not_allowed_terms( $args, $taxonomies ) {
    if(in_array( 'vso', $taxonomies ) ) {
        $args['meta_query'] = array(
            'relation' => 'OR',
            array(
                'key' => 'vso_active',
                'compare' => 'NOT EXISTS'
            ),
            array(
                'key'    => 'vso_active',
                'value'  => true
            )
        );
    }
    return $args;
}
add_filter( 'get_terms_defaults','exclude_not_allowed_terms', 20, 2 );

//changer le nombre de caractère mini pour password
add_filter( 'woocommerce_min_password_strength', 'reduce_min_strength_password_requirement' );
function reduce_min_strength_password_requirement( $strength ) {
    // 3 => Strong (default) | 2 => Medium | 1 => Weak | 0 => Very Weak (anything).
    return 2;
}

//disable change password
if ( !function_exists( 'wp_password_change_notification' ) ) {
    function wp_password_change_notification() {}
}


//bouton retour au shop quand panier vide
/**
 * Changes the redirect URL for the Return To Shop button in the cart.
 *
 * @return string
 */
function wc_empty_cart_redirect_url() {
    $baseShopURL = '/shop/?product_status=vente-boutique';
    if(get_locale() == 'en_US') {
        $baseShopURL = $baseShopURL.'&lang=en';
    }
    return $baseShopURL;
}
add_filter( 'woocommerce_return_to_shop_redirect', 'wc_empty_cart_redirect_url' );

//change proceed to checkout url for EN !!!
function woocommerce_button_proceed_to_checkout() {
    $checkout_url = WC()->cart->get_checkout_url();
    //Change link for EN version !!
    $cartENPageID = pll_get_post(intval(get_option( 'woocommerce_cart_page_id' )));
    $post= get_post();
    if($cartENPageID == $post->ID){
        $checkoutENPageID = pll_get_post(intval(get_option( 'woocommerce_checkout_page_id' )));
        $checkout_url = get_permalink($checkoutENPageID);
    }
    ?>
    <a href="<?php echo $checkout_url; ?>" class="checkout-button button alt wc-forward"><?php _e( 'Proceed to checkout', 'woocommerce' ); ?></a>
    <?php
}

//LABEL FR / EN for checkout / cart
add_filter( 'woocommerce_shipping_rate_label', 'change_shipping_methods_label_names', 10, 2 );
function change_shipping_methods_label_names( $this_label, $instance ) {
    $methodId = $instance->get_method_id();
    if($methodId == 'local_pickup') {
        $this_label = __( 'Retrait en boutique', 'bb-theme' );
    }
    return  $this_label;
}