<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

//show status
function modify_user_table( $column ) {
    $column['registered'] = 'Inscrit le';
    unset($column['posts']); //column Articles >  inutiles
    return $column;
}
add_filter( 'manage_users_columns', 'modify_user_table' );


function modify_user_table_row( $val, $column_name, $user_id ) {
    //setter nom et  prénom si ce n'est pas le cas, me !!
    $firstName = get_user_meta( $user_id, 'first_name', true );
    if($firstName == '') {
        $firstName = get_user_meta( $user_id, 'shipping_first_name', true );
        if($firstName == '') {
            $firstName = get_user_meta( $user_id, 'billing_first_name', true );
        }
        if($firstName != '') {
            update_user_meta( $user_id, 'first_name', $firstName );
        }
    }

    $lastName = get_user_meta( $user_id, 'last_name', true );
    if($lastName == '') {
        $lastName = get_user_meta( $user_id, 'shipping_last_name', true );
        if($lastName == '') {
            $lastName = get_user_meta( $user_id, 'billing_last_name', true );
        }
        if($lastName != '') {
            update_user_meta( $user_id, 'last_name', $lastName );
        }
    }

    //registration date
    $udata = get_userdata( $user_id );
    $registered = $udata->user_registered;
    $registerShow = date( "d/m/Y", strtotime( $registered ) );
    switch ($column_name) {
        case 'registered' :
            return $registerShow;
            break;
        default:
    }
    return $val;
}
add_filter( 'manage_users_custom_column', 'modify_user_table_row', 10, 3 );

/*
 * Make our "Registration date" column sortable
 */
add_filter( 'manage_users_sortable_columns', 'bb_make_registered_column_sortable' );

function bb_make_registered_column_sortable( $columns ) {
    return wp_parse_args( array( 'registered' => 'registered' ), $columns );
}

//pas d'avatar user
add_filter( 'option_show_avatars', '__return_false' );

//remove useless fields !
if( is_admin() ){
    remove_action( 'admin_color_scheme_picker', 'admin_color_scheme_picker');
}