<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

class TimberInit extends TimberSite {
    function __construct() {
//        add_theme_support( 'post-formats' );
//        add_theme_support( 'post-thumbnails' );
//        add_theme_support( 'title-tag' );
//        add_theme_support( 'menus' );
//        add_theme_support( 'widgets' );
        add_filter( 'timber_context', array( $this, 'add_to_context' ) );
        add_filter( 'get_twig', array( $this, 'add_to_twig' ) );
        add_action( 'init', array( $this, 'register_post_types' ) );
        add_action( 'init', array( $this, 'register_taxonomies' ) );
        add_action( 'init', array( $this, 'load_scripts' ) );

        parent::__construct();

        //Cache the Twig File (but not the data)
        if ( class_exists( 'Timber' ) ){
            Timber::$cache = true;
        }
    }

    function add_to_context( $context ) {
        $ICL_LANGUAGE_CODE = 'fr';
        if(get_locale() == 'en_US') {
            $ICL_LANGUAGE_CODE = 'en';
        }
        $context['menu'] = new Timber\Menu('main_menu');
        $context['site'] = $this;
        $context['siteName'] = get_bloginfo('name');
        $context['imgBase'] = "/wp-content/themes/bb-theme/assets/img/client/";
        $context['accountLabel'] = $this->getAccountLabel();
        $context['ICL_LANGUAGE_CODE'] = $ICL_LANGUAGE_CODE;
        return $context;
    }

    function getAccountLabel() {
        $label = __('Mon compte', 'bb-theme');
        if(is_user_logged_in()) {
            $user = wp_get_current_user();
            $label = $user->user_firstname; // or user_login , user_firstname, user_lastname
        }
        return $label;
    }

    function add_to_twig( $twig ) {
        /* this is where you can add your own fuctions to twig */
        $twig->addExtension( new Twig_Extension_StringLoader() );

        //INTL
        $twig->addExtension(new Twig_Extensions_Extension_Intl());

        $twig->addFilter( new Twig_SimpleFilter( 'sortByField',  function ($content, $sort_by, $direction = 'asc') {
            if (is_a($content, 'Doctrine\ORM\PersistentCollection')) {
                $content = $content->toArray();
            }
            if (!is_array($content)) {
                throw new \InvalidArgumentException('Variable passed to the sortByField filter is not an array');
            } elseif (count($content) < 1) {
                return $content;
            } else {
                @usort($content, function ($a, $b) use ($sort_by, $direction) {
                    $flip = ($direction === 'desc') ? -1 : 1;
                    if (is_array($a))
                        $a_sort_value = $a[$sort_by];
                    else if (method_exists($a, 'get' . ucfirst($sort_by)))
                        $a_sort_value = $a->{'get' . ucfirst($sort_by)}();
                    else
                        $a_sort_value = $a->$sort_by;
                    if (is_array($b))
                        $b_sort_value = $b[$sort_by];
                    else if (method_exists($b, 'get' . ucfirst($sort_by)))
                        $b_sort_value = $b->{'get' . ucfirst($sort_by)}();
                    else
                        $b_sort_value = $b->$sort_by;
                    if ($a_sort_value == $b_sort_value) {
                        return 0;
                    } else if ($a_sort_value > $b_sort_value) {
                        return (1 * $flip);
                    } else {
                        return (-1 * $flip);
                    }
                });
            }
            return $content;
        }) );

        //  CHECK IF PRODUCT IN CART
        $twig->addFilter( new Twig_SimpleFilter( 'isInCartProduct',  'matched_cart_items' ) );
            return $twig;
        }


    static function dump($var) {
        echo '<pre>';
        var_dump($var);
        echo '</pre>';
    }

    function matched_cart_items($product) {
        $productId = $product->get_id();
        if (!WC()->cart->is_empty()):
            // Initialise the count
            $count = 0;
            foreach (WC()->cart->get_cart() as $cart_item):
                $items_id = $cart_item['product_id'];
                // for a unique product ID (integer or string value)
                if ($productId == $items_id) {
                    $count++; // incrementing the counted items
                }
            endforeach;
            // returning counted items
            return $count;
        endif;
    }


}


