<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

// ==== FUNCTIONS ==== //
require_once(get_template_directory().'/functions/init.php');

//settings custom

//register nav menus
function register_my_menus() {
  register_nav_menus([
      'main-menu' => __( 'Main Menu', 'bb-theme' ),
      'footer-menu' => __( 'Footer Menu', 'bb-theme' ),]);

}
add_action( 'init', 'register_my_menus' );

//add scriptsget_template_directory_uri()
function BB_add_scripts() {
    $version = 'v01';
    if (WP_DEBUG) {
        $version = time();
    }
//    $api_key = get_option( 'bb_google_map_api_key' );
    //if in [] we add jquery, jquery will be added in header by wordpress ...
//    wp_enqueue_script( 'bootstrap', get_stylesheet_directory_uri() . '/assets/js/bootstrap.min.js', ['jquery'], $version, true );
//    wp_enqueue_script( 'googleMap', 'https://maps.googleapis.com/maps/api/js?key='.$api_key, [], $version, true );
//    wp_enqueue_script( 'bb_map', get_stylesheet_directory_uri() . '/assets/js/bb-gmap.js' , [], $version, true );
    wp_enqueue_script( 'bb_js', get_stylesheet_directory_uri() . '/assets/dist/js/app.min.js' , [], $version, true );
    //style
    wp_enqueue_style( 'main', get_template_directory_uri() . '/assets/dist/css/main.min.css', false, $version, 'all');

}
add_action( 'wp_enqueue_scripts', 'BB_add_scripts', 1000 );

add_theme_support( 'custom-logo' );
function bbtheme_logo_setup() {
    $defaults = array(
        'height'      => 70,
        'flex-width'  => true,
        'header-text' => array( 'site-title', 'site-description' ),
    );
    add_theme_support( 'custom-logo', $defaults );
    add_theme_support( 'post-thumbnails'); //allow thumbnail option
    //yoast seo title
    add_theme_support( 'title-tag' );
//    //woocommerce
//    add_theme_support( 'woocommerce' );
}
add_action( 'after_setup_theme', 'bbtheme_logo_setup' );

//security on WordPress
remove_action("wp_head", "wp_generator");
//add_filter('login_errors',create_function('$a', "return null;"));
define('DISALLOW_FILE_EDIT',true);

//remove unusefull head lines
remove_action('wp_head', 'wlwmanifest_link');
remove_action('wp_head', 'rsd_link');
remove_action( 'wp_head', 'wp_shortlink_wp_head');

function custom_excerpt_length( $length ) {
    return 50;
}
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );

//spé BLOG category
add_action( 'init', 'bb_rewrite_add_rewrites' );
function bb_rewrite_add_rewrites() {
    add_rewrite_rule('^categorie/(.+)/page/?([0-9]{1,})/?$', 'index.php?taxonomy=category&term=$matches[1]&paged=$matches[2]', 'top');
    add_rewrite_rule('^categorie/(.+)/(.+)$','index.php?taxonomy=category&term=$matches[1]','top');
}


/**
 * Reusable Blocks accessible in backend
 * @link https://www.billerickson.net/reusable-blocks-accessible-in-wordpress-admin-area
 *
 */
function bb_reusable_blocks_admin_menu() {
    $user = wp_get_current_user();
    $roles = $user->roles;
    if( in_array('gestionnaire', $roles)) {
        add_menu_page( 'Reusable Blocks', 'Reusable Blocks', 'edit_posts', 'edit.php?post_type=wp_block', '', 'dashicons-editor-table', 22 );
    }
}
add_action( 'admin_menu', 'bb_reusable_blocks_admin_menu' );


function wpc_mime_types($mimes) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter('upload_mimes', 'wpc_mime_types');


function admin_css() {
    $admin_handle = 'admin_css';
    $admin_stylesheet = get_template_directory_uri() . '/admin.css';
    wp_enqueue_style($admin_handle, $admin_stylesheet);
}
add_action('admin_print_styles', 'admin_css', 11);

function wpcf7_dequeue_redundant_scripts() {
    if ( !is_page('contact') ) {
        wp_dequeue_script( 'contact-form-7' );
        wp_dequeue_style( 'contact-form-7' );
        wp_dequeue_script( 'wpcf7-recaptcha' );
        wp_dequeue_style( 'wpcf7-recaptcha' );
        wp_dequeue_script( 'google-recaptcha' );
    }
}
add_action( 'wp_enqueue_scripts', 'wpcf7_dequeue_redundant_scripts', 99 );