<?php  if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }
global $paged;
if (!isset($paged) || !$paged){
    $paged = 1;
}
$postsPerPage = 9;
$offset = ( $paged - 1 ) * $postsPerPage;

$context = Timber::get_context();

$args = array(
    'posts_per_page'   => $postsPerPage,
    'paged'            => $paged,
    'offset'           => $offset,
    'orderby'          => 'date',
//    'orderby'          => 'modified',
    'order'            => 'DESC'
);

if (is_tag()) {
    $context['subTitle'] = 'Mot-clef: ' .  single_tag_title('', false);
    $args['tag_id']  = ( get_queried_object() )->term_id;
} elseif (is_category()) {
    $context['subTitle'] = 'Catégorie: ' . single_cat_title('', false);
    $args['cat']  = ( get_queried_object() )->term_id;
}

$context['taxonomy'] = new \Timber\Term( get_queried_object() );
$context['posts']      = new Timber\PostQuery($args);
$context['pagination'] = Timber::get_pagination();

$templates = array( 'modules/blog/archive.twig' );
Timber::render($templates, $context);